module.exports = function (blocks) {
    blocks.declare('b-page_type_partners-news', function (data) {
        var titleData = data.title;
        var pageContent = data.post ? {
            block: 'news-info',
            mods: { type: 'post' },
            elem: 'post',
            post: data.post,
            blogUrl: data.blog.blogUrl,
            articleCta: data.articleCta
        } : {
            block: 'partners-info',
            mods: { page: 'news' },
            data: data
        };

        return [
            {
                block: 'main-layout',
                mods: { wide: 'yes' },
                left: null,
                right: [
                    {
                        block: 'page-content',
                        content: [
                            {
                                elem: 'title',
                                content: titleData.title
                            },
                            titleData.description && {
                                elem: 'text',
                                mix: { block: 'html-content' },
                                text: titleData.description
                            }
                        ]
                    },
                    data.showNewspageControls && {
                        block: 'news-selects-filters',
                        data: data
                    },
                    pageContent
                ]
            },
            blocks.exec('levels', data)
        ];
    });
};
