module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./event-info-mock.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'gemini-resizer',
                    mods: { type: 'no-experts' },
                    content: [
                        {
                            block: 'event-info',
                            event: data.noExperts
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'similar-months' },
                    content: [
                        {
                            block: 'event-info',
                            event: data.similarMonths,
                            experts: data.experts,
                            expertSlugToUrl: data.expertSlugToUrl
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'one-date' },
                    content: [
                        {
                            block: 'event-info',
                            event: data.oneDate,
                            experts: data.experts,
                            expertSlugToUrl: data.expertSlugToUrl
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'long-text-hyphenation' },
                    content: [
                        {
                            block: 'event-info',
                            event: data.longTextHyphenation,
                            experts: data.experts,
                            expertSlugToUrl: data.expertSlugToUrl
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'long-name' },
                    content: [
                        {
                            block: 'event-info',
                            event: data.longName,
                            experts: data.experts,
                            expertSlugToUrl: data.expertSlugToUrl
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'incorrect-date' },
                    content: [
                        {
                            block: 'event-info',
                            event: data.incorrectDate,
                            experts: data.experts,
                            expertSlugToUrl: data.expertSlugToUrl
                        }
                    ]
                }
            ]
        };
    });
};
