module.exports = function (bh) {
    bh.match('expert-page__left', function (ctx, json) {
        var expert = json.expert;
        var eduExpert = json.eduExpert;
        var certByYandex = json.certByYandex;

        ctx.content([
            {
                elem: 'name',
                content: expert.name
            },
            {
                elem: 'image',
                imageUrl: expert.bigPhoto
            },
            eduExpert && {
                elem: 'plate',
                eduExpert: eduExpert,
                certByYandex: certByYandex
            },
            {
                elem: 'certificates',
                certificates: expert.certificates,
                verificationUrl: expert.verificationUrl
            },
            {
                elem: 'description',
                content: expert.description
            },
            {
                elem: 'text',
                expert: expert
            },
            {
                block: 'solution-info',
                elem: 'info-brief',
                info: json.info
            },
            expert.contactFormButton && {
                elem: 'contact-button',
                linkForConnect: expert.linkForConnect
            }
        ]);
    });

    bh.match('expert-page__right', function (ctx, json) {
        var expert = json.expert;
        var filters = json.filters;
        var workFormats = expert.workFormats;
        var events = json.events;
        var reviews = expert.reviews;
        var searchUrl = json.searchUrl;

        ctx.content([
            filters && filters.length ? filters.map(function (filter) {
                return {
                    elem: 'filter',
                    data: filter,
                    searchUrl: searchUrl
                };
            }) : null,
            {
                elem: 'specializations',
                specializations: expert.specializations,
                searchUrl: searchUrl
            },
            {
                elem: 'work-formats',
                workFormats: workFormats,
                searchUrl: searchUrl
            },
            {
                elem: 'events',
                events: events,
                eventSlugToUrl: json.eventSlugToUrl,
                expertSlugToName: json.expertSlugToName
            },
            {
                elem: 'reviews',
                reviews: reviews
            },
            expert.feedbackForm && {
                elem: 'feedback-button',
                name: expert.name
            }
        ]);
    });

    bh.match('expert-page__feedback-button', function (ctx, json) {
        var formsUrl = bh.lib.global.formsUrl;

        ctx.content({
            block: 'button2',
            mods: { theme: 'normal', size: 'm', type: 'link' },
            text: bh.lib.i18n('edu', 'leave.feedback'),
            url: bh.lib.util.placeholder('{s}8500?freelancer={s}', formsUrl, json.name)
        });
    });
};
