BEM.DOM.decl('horizontal-select', {
    onSetMod: {
        js: {
            inited: function () {
                this.__base.apply(this, arguments);

                this.bindTo(this.domElem, 'touchstart', this._onTouchStart.bind(this));
                this.bindTo(this.domElem, 'touchend', this._onTouchEnd.bind(this));
                this.bindTo(this.domElem, 'touchmove', this._onTouchMove.bind(this));
                this.bindTo(this.domElem, 'touchcancel', this._onTouchCancel.bind(this));
            }
        }
    },

    _onTouchStart: function(event) {
        this._dragStart(event.originalEvent.touches[0].pageX);
    },

    _onTouchMove: function(event) {
        this._drag(event.originalEvent.touches[0].pageX);
    },

    _onTouchEnd: function(event) {
        this._dragEnd(event);
    },

    _onTouchCancel: function(event) {
        this._cancelScrolling(event);
    },

    _calcScrollOffset: function(position, width, index) {
        // У всех, кроме первого нужно уменьшить смещений, потому что у них есть отступ
        // А первому элементу наоборот немного добавить
        var additionalOffset = 20 * (index === 0 ? -1 : 1);

        return position.left + additionalOffset;
    }
});
