BEM.DOM.decl('lesson-tabs', {
    onSetMod: {
        js: {
            inited: function () {
                this.__base.apply(this, arguments);

                this._scrollableArea = this.findElem('titles');
                this._areaWidth = this._scrollableArea.width();

                var sumTitlesWidth = 0;

                for (var idx = 0; idx < this._titles.length; idx += 1) {
                    sumTitlesWidth += $(this._titles[idx]).width();
                }

                if (sumTitlesWidth <= this._areaWidth) {
                    this.delMod(this._titles, 'width');
                }
            }
        }
    },

    _animationDuration: 300,

    // Поля слева и справа
    _margins: 16,

    /**
     * Если отрыли вкладку, которая видна не полностью, прокручиваем вкладки до активной
     * @param {Object} e
     * @private
     */
    _onTitleClick: function (e) {
        this.__base.apply(this, arguments);

        var $title = e.data.domElem;

        // Левая и правая границы прокручиваемой области
        var areaLeftBorder = this._scrollableArea.scrollLeft();
        var areaRightBorder = this._areaWidth + areaLeftBorder;

        // Параметры вкладки, на которую нажали
        var tabWidth = $title.width();
        var tabLeftBorder = areaLeftBorder + $title.position().left;
        var tabRightBorder = tabLeftBorder + tabWidth;

        // Прокрутка осуществляется настолько, чтобы вкладка открылась по центру
        var centerDiff = (this._areaWidth - tabWidth) / 2;
        var leftDiff = tabLeftBorder - areaLeftBorder;
        var rightDiff = tabRightBorder - areaRightBorder;

        // Устанавливаем новый отступ слева
        var scrollLeft = 0;

        if (rightDiff >= -this._margins) {
            scrollLeft = areaLeftBorder + rightDiff + centerDiff;
        } else if (leftDiff <= this._margins) {
            scrollLeft = areaLeftBorder + leftDiff - centerDiff;
        }

        if (scrollLeft) {
            this._scrollableArea.animate({ scrollLeft: scrollLeft }, this._animationDuration);
        }
    }
});
