module.exports = function (bh) {
    'use strict';
    bh.match('level-image2', function (ctx, json) {
        var level = json.level;

        ctx.content([
            {
                elem: 'image',
                image: bh.lib.util.mds(json.level.image, 'news_image_m_2x'),
                level: level
            },
            {
                elem: 'description',
                mix: { block: 'html-content' },
                content: level.description
            }
        ]);
    });

    bh.match('level-image2__image', function (ctx, json) {
        var level = json.level;
        var image = json.image;

        ctx
            .mods({
                font: level.black && 'dark',
                background: image && 'image'
            })
            .attrs({
                style: image && 'background-image: url("' + image + '");'
            })
            .content({
                elem: 'title',
                content: level.text
            });
    });
};
