module.exports = function (blocks, blockName) {
    'use strict';
    var types = ['form', 'all', 'facebook'];

    blocks.declare(blockName, function () {
        var base = require('./level-subscribe-mock.json');

        return {
            block: blockName,
            content: types.map(function (item) {
                return {
                    block: 'level-subscribe',
                    mods: {
                        type: (item === 'form' || item === 'all') ? item : 'single'
                    },
                    shareLevel: Object.assign({}, base, {
                        type: item
                    })
                };
            })
        };
    });
};
