module.exports = function (bh) {
    'use strict';
    bh.match('level_type_journal', function (ctx, json) {
        var image = json.level.image;
        var imageUrl = json.level.lowQuality ? bh.lib.util.mds(image, 'mainpage_journal_m') : image;

        ctx.tParam('mdsImage', imageUrl);
    });

    bh.match('level__player', function (ctx) {
        ctx
            .mix({ block: 'html-content' })
            .content(ctx.content(), true);
    });

    bh.match('level__content_type_journal', function (ctx, json) {
        ctx.content({
            elem: 'scrollable',
            content: json.columns
        });
    });

    bh.match('level__not-supported', function (ctx) {
        ctx.content([
            { elem: 'not-supported-image' },
            { elem: 'not-supported-description' }
        ]);
    });
};
