module.exports = function (bh) {

    bh.match('level_type_showcase__product', function (ctx, data) {
        var product = data.product;

        if (!product) {
            return '';
        }

        ctx
            .tag('a')
            .attrs({ href: product.url })
            .content(
                [
                    product.title && {
                        tag: 'h4',
                        elem: 'product-title',
                        content: product.title
                    }
                ]
            );
    });

    bh.match('level_type_showcase__cta', function (ctx, data) {
        var cta = data.cta;

        if (!cta) {
            return '';
        }

        ctx.content(
            [
                cta.mobileButtonText && {
                    block: 'button2',
                    mods: {
                        size: 'l',
                        theme: 'normal',
                        type: 'link',
                        view: 'default',
                        tone: 'grey',
                        cta: true,
                        width: 'max'
                    },
                    url: cta.url,
                    text: cta.mobileButtonText
                }
            ]
        );
    });
};

