module.exports = function (bh) {
    bh.match('level_type_text2', function (ctx, json) {
        var level = json.level;
        var themeLink = level.themeLink;
        var text = themeLink && themeLink.text;

        ctx.content([
            text && {
                elem: 'theme',
                themeLink: themeLink
            }
        ]);
    });

    bh.match('level__img', function (ctx, json) {
        var src = json.imageType === 'image' ?
            bh.lib.util.mds(json.imageUrl, 'mainpage_text_large_m_2x') :
            json.imageUrl;

        ctx.attrs({
            src: src
        });
    });
};
