module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var levels = require('./level-mock.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'gemini-resizer',
                    mods: { type: 'news' },
                    content: {
                        block: 'level',
                        newsPage: '#',
                        mods: { type: 'news' },
                        level: levels.news,
                        commentsData: levels.commentsData
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'text' },
                    content: {
                        block: 'level',
                        newsPage: '#',
                        mods: { type: 'text' },
                        level: levels.text,
                        commentsData: levels.commentsData
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'long-text' },
                    content: {
                        block: 'level',
                        newsPage: '#',
                        mods: { type: 'text' },
                        level: levels.longText,
                        commentsData: levels.commentsData
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'video' },
                    content: {
                        block: 'level',
                        newsPage: '#',
                        mods: { type: 'video' },
                        level: levels.video,
                        commentsData: levels.commentsData
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'journal' },
                    content: {
                        block: 'level',
                        newsPage: '#',
                        mods: { type: 'journal' },
                        level: levels.journal,
                        commentsData: levels.commentsData
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'text2' },
                    content: {
                        block: 'level',
                        eduPage: '#',
                        mods: { type: 'text2' },
                        level: levels.text2
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'head' },
                    content: {
                        block: 'level',
                        mods: { type: 'head' },
                        level: levels.head
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'icon' },
                    content: {
                        block: 'level',
                        mods: { type: 'text' },
                        level: levels.icon
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'image3' },
                    content: {
                        block: 'level',
                        mods: { type: 'image3' },
                        level: levels.image3
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'help' },
                    content: [
                        {
                            block: 'level',
                            mods: { type: 'help' },
                            level: levels.help
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'sharing' },
                    content: {
                        block: 'level',
                        mods: { type: 'sharing' },
                        level: levels.sharing
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'showcase' },
                    content: {
                        block: 'level',
                        mods: { type: 'showcase' },
                        level: levels.showcase
                    }
                },
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'height: 358px;' },
                    mods: { type: 'publishers' },
                    content: {
                        block: 'level',
                        mods: { type: 'publishers' },
                        level: levels.publishers
                    }
                },
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'height: 358px;' },
                    mods: { type: 'video2' },
                    content: {
                        block: 'level',
                        mods: { type: 'video2' },
                        level: levels.video2
                    }
                }
            ]
        };
    });
};
