module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./main-layout-nock.json');

        var product = data.product;
        var sections = data.sections;

        return {
            block: blockName,
            content: [
                {
                    block: 'main-layout',
                    mods: { 'sticky-left': 'yes' },
                    right: {
                        block: 'page-content',
                        content: [
                            {
                                elem: 'title',
                                content: product.title
                            },
                            product.text && {
                                elem: 'text',
                                mix: { block: 'html-content' },
                                image: product.image,
                                imageAlign: product.imageAlign,
                                text: product.text
                            },
                            sections
                        ]
                    }
                }
            ]
        };
    });
};
