BEM.DOM.decl('main-layout', {
    onSetMod: {
        js: function () {
            this._button = this.elem('button');
            this._page = this.findBlockOutside('b-page');
            this._paranja = this.findBlockInside('paranja');
            this._$leftAside = this.elem('left');
            this._leftAside = this._$leftAside[0];
            this._initialCoords = 0;

            this._bindEvents();
        }
    },

    _bindEvents: function () {
        this.bindTo('left', 'touchmove touchstart', this._breakScroll.bind(this));
        this.bindTo('button', 'touchmove scroll', this._stopScroll);

        if (this._paranja) {
            this._paranja.domElem.on('touchmove scroll', this._stopScroll);
            this._paranja.on('close', this.hide.bind(this));
        }

        this.bindTo(this._button, 'pointerclick', this._onChangeClickButton.bind(this));

        this._swipeLeft();
    },

    _swipeLeft: function () {
        var xStart = null;
        var yStart = null;
        var startTime = null;

        this.bindToWin('touchstart', function (e) {
            xStart = e.originalEvent.changedTouches[0].clientX;
            yStart = e.originalEvent.changedTouches[0].clientY;
            startTime = new Date().getTime();
        });

        /* eslint-disable complexity */
        this.bindToWin('touchend', function (e) {
            if (!xStart || !this.hasMod(this._$leftAside, 'opened', 'yes')) {
                return;
            }
            var xCurrent = e.originalEvent.changedTouches[0].clientX;
            var yCurrent = e.originalEvent.changedTouches[0].clientY;
            var xDiff = xStart - xCurrent;
            var yDiff = yStart - yCurrent;
            var endTime = new Date().getTime();
            var diffTime = endTime - startTime;
            var MIN_DISTANCE = 50;
            var MAX_INTERVAL = 200;

            /* eslint-disable max-len */
            // Swipe left
            if (Math.abs(xDiff) > Math.abs(yDiff) && xDiff > MIN_DISTANCE && diffTime < MAX_INTERVAL) {
                this.hide();
            }
        });
        /* eslint-enable complexity */
    },

    _onChangeClickButton: function () {
        if (this.hasMod(this._$leftAside, 'opened', 'yes')) {
            this.hide();

            return;
        }
        this.show();
    },

    _stopScroll: function (e) {
        e.preventDefault();
    },

    _breakScroll: function (e) {
        /* eslint-disable no-unused-expressions */
        var coords = e.originalEvent.touches[0].pageY;

        if (e.type === 'touchstart') {
            this._initialCoords = coords;

            return;
        }
        if (this._initialCoords <= coords) {
            this._leftAside.scrollTop <= 0 && e.preventDefault();

            return;
        }
        this._leftAside.scrollTop >= this._leftAside.scrollHeight - this._leftAside.offsetHeight && e.preventDefault();
    },

    hide: function () {
        this.delMod(this._$leftAside, 'opened');
        this._page.delMod('scroll');
        this._paranja.setMod('state', 'close');
    },

    show: function () {
        this.setMod(this._$leftAside, 'opened', 'yes');
        this._page.setMod('scroll', 'disabled');
        this._paranja.setMod('state', 'open');
    }
});
