module.exports = function (blocks, blockName) {
    'use strict';

    blocks.declare(blockName, function () {
        var data = require('./news-list.json');

        return [
            {
                block: blockName,
                content: {
                    block: 'main-layout',
                    content: [
                        {
                            block: 'page-content',
                            content: [
                                {
                                    elem: 'title',
                                    content: data.title.title
                                },
                                data.title.description && {
                                    elem: 'text',
                                    mix: { block: 'html-content' },
                                    text: data.title.description
                                }
                            ]
                        },
                        {
                            block: 'news-selects-filters',
                            mods: { layout: 'content' },
                            data: data
                        },
                        {
                            block: 'level',
                            mods: { type: 'journal' },
                            url: '#',
                            level: data.journal,
                            page: data.page
                        },
                        {
                            block: 'news-list',
                            data: data
                        }
                    ]
                }
            }
        ];
    });
};
