module.exports = function (bh) {
    bh.match('offices', function (ctx) {
        ctx
            .js({
                control: 'select'
            })
            .tag('section');
    });

    bh.match('offices__controls', function (ctx) {
        var selectedCountry = ctx.param('selectedCountry');
        var countries = ctx.param('countries');

        ctx.content({
            block: 'select',
            mods: { size: 'm', layout: 'content', theme: 'normal', width: 'available' },
            content: [
                {
                    block: 'button',
                    mods: { theme: 'normal' },
                    content: countries[selectedCountry]
                },
                {
                    elem: 'control',
                    content: Object.keys(countries).map(function (countryName) {
                        return {
                            elem: 'option',
                            attrs: { value: countryName },
                            content: countries[countryName]
                        };
                    })
                }
            ]
        });
    });
};
