module.exports = function (bh) {
    bh.match('order-list', function (ctx) {
        ctx.js({
            control: 'select'
        });
    });

    bh.match('order-list__switcher', function (ctx) {
        var sections = ctx.param('sections');
        var currentSection = ctx.param('current');
        var currentSectionName = '';
        var sectionsJson = sections.map(function (section) {
            var isSelected = false;

            if (section.id === currentSection) {
                isSelected = true;
                currentSectionName = section.title;
            }

            return {
                elem: 'option',
                attrs: {
                    value: section.id,
                    selected: isSelected
                },
                content: section.title
            };
        });

        ctx.content({
            block: 'select',
            mods: { size: 'm', layout: 'content', theme: 'normal', width: 'available' },
            content: [
                {
                    block: 'button',
                    mods: { theme: 'normal' },
                    content: currentSectionName
                },
                {
                    elem: 'control',
                    content: sectionsJson
                }
            ]
        });
    });
};
