BEM.DOM.decl('poster', {
    onSetMod: {
        js: {
            inited: function () {
                this.__base.apply(this, arguments);

                this._preventScroll = false;

                this._addScrollHandlers();
            }
        }
    },

    _addScrollHandlers: function() {
        if (this._carousel) {
            this._carousel.on('drag.owl.carousel', this._onCarouselDragStart.bind(this));
            this._carousel.on('draged.owl.carousel', this._onCarouselDragEnd.bind(this));

            document.addEventListener(
                'touchmove',
                this._onDocumentTouchMove.bind(this),
                { passive: false }
            );
            document.addEventListener('touchend', this._onDocumentTouchCancel.bind(this));
            document.addEventListener('touchcancel', this._onDocumentTouchCancel.bind(this));
        }
    },

    _onDocumentTouchMove: function(event) {
        if (this._preventScroll) {
            event.preventDefault();
        }
    },

    _onDocumentTouchCancel: function() {
        this._preventScroll = false;
    },

    _onCarouselDragStart: function() {
        this._preventScroll = true;
    },

    _onCarouselDragEnd: function() {
        this._preventScroll = false;
    }
});
