module.exports = function (bh) {
    'use strict';
    bh.match('product-chart-bars__chart-toggle', function (ctx, json) {
        if (!ctx.tParam('hasToggle')) {
            return '';
        }

        ctx.content({
            block: 'select',
            name: 'mail',
            mods: { size: 'm', theme: 'normal' },
            content: [
                {
                    block: 'button',
                    mods: { theme: 'normal' },
                    content: json.data[0].name
                },
                {
                    elem: 'control',
                    content: json.data.map(function (item, index) {
                        return {
                            elem: 'option',
                            content: item.name,
                            attrs: {
                                value: index,
                                selected: index === 0 && 'selected'
                            }
                        };
                    })
                }
            ]
        });
    });
};
