module.exports = function (bh) {
    function wrapCards(card) {
        return card && {
            elem: 'card-wrapper',
            content: card
        };
    }

    bh.match('product-media-cards__items', function (ctx, json) {
        ctx.content(json.items);
    });

    bh.match('product-media-cards__items_scrollable_yes', function (ctx, json) {
        ctx.content({
            elem: 'scrollable',
            content: json.items.map(wrapCards)
        });
    });

    bh.match('product-media-cards__card', function (ctx, json) {
        var data = json.data;
        var hasTextOnTouchPhone = data.hasTextOnTouchPhone;
        var hasMoreOnTouchPhone = data.hasMoreOnTouchPhone;

        ctx
            .mods({
                text: hasTextOnTouchPhone ? 'yes' : 'no',
                more: hasMoreOnTouchPhone ? 'yes' : 'no'
            })
            .content(hasTextOnTouchPhone && {
                elem: 'card-text',
                text: data.text
            });
    });

    bh.match('product-media-cards__card-image', function (ctx, json) {
        if (json.hasTextOnTouchPhone) {
            return '';
        }
    });

    bh.match('product-media-cards__card-link', function (ctx, json) {
        if (!json.hasTextOnTouchPhone) {
            return '';
        }

        var hasLink = json.hasMoreOnTouchPhone && json.url;

        ctx.content(hasLink && [
            {
                elem: 'card-link-text',
                content: json.text
            },
            { elem: 'card-link-icon' }
        ]);
    });
};
