BEM.DOM.decl('sidebar', {
    /* eslint-disable complexity */

    _scrollCloseAccuracy: 100,

    _handleAnimationEnd: function () {
        this.bindTo('touchmove touchstart', this._stopScroll.bind(this));
    },

    _stopScroll: function (e) {
        var coords = e.originalEvent.touches[0].pageY;

        if (e.type === 'touchstart' || !this._activeContent) {
            this._initialCoords = coords;

            return;
        }

        var content = this._activeContent[0];
        var isVerticalSwipe = this._initialCoords <= coords && content.scrollTop <= 0;
        var scrollDifference = content.scrollHeight - content.offsetHeight;
        var isScrolledDown = this._initialCoords > coords &&
            content.scrollTop >= scrollDifference;

        if (isVerticalSwipe || isScrolledDown) {
            e.preventDefault();
        }
    },

    _slideContent: function () {
        this.afterCurrentEvent(function () {
            this.setMod('pushed', 'yes');
        }.bind(this));
    },

    _slideContentBack: function () {
        this.afterCurrentEvent(function () {
            this.delMod('pushed');
        }.bind(this));
    }
});
