module.exports = function (bh) {
    function getFooterInfo(info) {
        if (!info || !info.length) {
            return;
        }

        return info.map(function (item) {
            return {
                elem: 'info-item',
                content: [
                    {
                        elem: 'item-label',
                        content: item.label
                    },
                    {
                        elem: 'item-value',
                        content: item.value
                    }
                ]
            };
        });
    }

    bh.match('solution-info__footer-row', function (ctx, json) {
        var solution = json.solution;
        var footer = solution.footer;
        var button = footer.button;

        ctx.content([
            {
                elem: 'share',
                og: {
                    title: solution.title,
                    description: solution.description,
                    image: solution.image
                }
            },
            {
                elem: 'footer-left',
                content: getFooterInfo(footer.info) || button.url && {
                    block: 'button2',
                    mods: {
                        theme: 'normal',
                        size: 'l',
                        type: 'link',
                        width: 'max'
                    },
                    text: button.text,
                    url: button.url
                }
            }
        ]);
    });

    bh.match('solution-info__image', function (ctx, json) {
        ctx.attrs({
            src: bh.lib.util.mds(json.solution.image, 'mainpage_text_large_m_2x')
        });
    });

    bh.match('solution-info__share', function (ctx, json) {
        var ogData = json.og;

        ctx.content({
            block: 'share',
            mods: { size: 'l' },
            ogData: ogData
        });
    });
};
