module.exports = function (bh) {

    /**
     * Возвращает bem-json для переданного изображения
     * @param {String} image
     * @returns {{block: String, elem: String, image: String}}
     */
    function renderImage(image) {
        return {
            block: 'gallery',
            elem: 'image',
            image: image
        };
    }

    bh.match('solution-page-block__gallery', function (ctx, json) {
        var images = json.images;

        ctx.content(images.length === 1 ? renderImage(images[0]) : {
            block: 'owl-carousel',
            mods: { type: 'dots' },
            js: {
                options: {
                    autoWidth: false,
                    dots: true,
                    dotData: bh.apply({
                        block: 'product-formats2',
                        elem: 'dot'
                    }),
                    items: 1,
                    nav: false
                }
            },
            content: images.map(renderImage)
        });
    });
};
