module.exports = function (bh) {
    bh.match('top-menu', function (ctx) {
        var items = ctx.param('items');
        var current = '–';
        var currentSection = ctx.param('currentSection');

        items.forEach(function (item) {
            if (item.id === currentSection) {
                current = item.name;
            }
        });

        ctx
            .tag('nav')
            .content([
                {
                    block: 'paranja',
                    mods: { autoclosable: 'yes' },
                    js: {
                        rel: [
                            { elem: '.paranja', event: 'pointerclick', method: 'close' }
                        ]
                    }
                },
                {
                    elem: 'current',
                    content: current
                },
                {
                    elem: 'list',
                    items: items,
                    currentSection: ctx.param('currentSection')
                }
            ]);
    });

    bh.match('top-menu__list', function (ctx) {
        var currentSection = ctx.param('currentSection');
        var items = ctx.param('items').map(function (item) {
            return {
                elem: 'item',
                current: currentSection && item.id === currentSection,
                item: item
            };
        });

        ctx
            .tag('ul')
            .content(items);
    });

    bh.match('top-menu__item', function (ctx) {
        var item = ctx.param('item');
        var content = item.url ? {
            elem: 'link',
            url: item.url,
            name: item.name
        } : [
            {
                elem: 'submenu-title',
                item: item
            },
            {
                elem: 'list',
                items: item.items
            }
        ];

        ctx
            .tag('li')
            .mod('current', ctx.param('current'))
            .content(content);
    });

    bh.match('top-menu__link', function (ctx) {
        ctx
            .tag('a')
            .attr('href', ctx.param('url'))
            .content(ctx.param('name'));
    });

    bh.match('top-menu__submenu-title', function (ctx) {
        var item = ctx.param('item');

        ctx.content(item.name);
    });
};
