BEM.DOM.decl('top-menu', {
    onSetMod: {
        js: {
            inited: function () {
                this._openedItem = null;
                this._paranja = this.findBlockInside('paranja');
                this._menuItems = this.elem('item');

                this._placeTopMenu.apply(this);

                this.bindEvents();
            }
        },
        opened: {
            '': function () {
                this._paranja.setMod('state', 'close');
            },
            yes: function () {
                this._paranja.setMod('state', 'open');
            }
        }
    },

    bindEvents: function () {
        this.bindTo('current', 'pointerclick', this._toggleDropdown);
        this.bindTo('submenu-title', 'pointerclick', this._toggleSubmenu);

        this._paranja.on('close', this._closeDropdown.bind(this));
    },

    _closeDropdown: function () {
        this.delMod('opened');
        this.delMod(this._menuItems, 'opened');
    },

    _toggleDropdown: function () {
        this.toggleMod('opened', 'yes', '');
    },

    _toggleSubmenu: function (e) {
        var currentMenuItem = $(e.target).parent();

        this._menuItems.each(function (index, submenu) {
            var $submenu = $(submenu);

            if (currentMenuItem.is(submenu) && !this.hasMod($submenu, 'opened', 'yes')) {
                this.setMod($submenu, 'opened', 'yes');

                return;
            }

            this.delMod($submenu, 'opened');
        }.bind(this));
    }
});
