module.exports = function (blocks) {
    var js = [
        { url: 'https://yastatic.net/jquery/1.12.0/jquery.min.js' },
        { url: 'https://yastatic.net/es5-shims/0.0.2/es5-shims.min.js', ie8: true },
        { url: '../../common/_common.js' }
    ];

    var css = [
        { url: '../../common/_common.css' },
        { url: '../../common/_common.ie9.css', ie: 9 }
    ];

    var meta = [
        { 'http-equiv': 'X-UA-Compatible', content: 'IE=edge' }
    ];

    blocks.declare('gemini-page', function (options) {
        BEM.I18N.lang('ru');

        return [
            {
                block: 'i-global',
                params: {
                    isTouch: true,
                    isMobile: true,
                    lang: 'ru',
                    userEmail: 'testagency@yandex.ru',
                    siteSearchUrl: '#',
                    shareServices: ['facebook', 'vkontakte', 'twitter', 'moimir', 'odnoklassniki']
                }
            },
            '<!DOCTYPE html>',
            {
                tag: 'html',
                mix: { block: 'i-ua', mods: { js: 'no' } },
                content: [
                    {
                        tag: 'head',
                        content: [

                            { tag: 'meta', attrs: { charset: 'utf-8' } },

                            meta.map(function (attrs) {
                                return { tag: 'meta', attrs: attrs };
                            }),

                            {
                                tag: 'meta',
                                attrs: {
                                    name: 'viewport',
                                    content: 'width=device-width, minimum-scale=1,maximum-scale=1, initial-scale=1,user-scalable=no'
                                }
                            },

                            { tag: 'title', content: options.title },

                            css.map(function (file) {
                                return { block: 'gemini-page', elem: 'css', file: file };
                            })
                        ]
                    },
                    {
                        tag: 'body',
                        block: 'gemini-page',
                        mix: [
                            {
                                block: 'i-global', js: {
                                tld: 'ru',
                                isTouch: true,
                                regions: require(`${__dirname}/blocks/gemini-page/main-menu-regions.json`),
                                siteSearchUrl: '#'
                            }
                            },
                            { block: 'b-page', elem: 'body' }
                        ],
                        content: [{
                            elem: 'inner',
                            mix: [
                                { block: 'b-page', elem: 'inner' }
                            ],
                            content: blocks.exec(options.blockName)
                        },
                            js.map(function (file) {
                                return { block: 'gemini-page', elem: 'js', file: file };
                            })
                        ]
                    }
                ]
            }
        ];
    });
};
