declare module 'ya-share' {
    interface IYaShareContent {
        url?: string;
        description?: string;
        image?: string;
        title?: string;
    }

    interface IYaShareContentByService {
        [service: string]: IYaShareContent;
    }

    type IYaShareLanguage =
        | 'az'
        | 'be'
        | 'en'
        | 'hy'
        | 'ka'
        | 'kk'
        | 'ro'
        | 'ru'
        | 'tr'
        | 'tt'
        | 'uk';

    interface IYaShareTheme {
        bare: boolean;
        lang: IYaShareLanguage;
        size: string;
        services: string;
    }

    interface IYaShareSettings {
        content?: IYaShareContent;
        contentByService?: IYaShareContentByService;
        theme: IYaShareTheme;
    }

    interface IYaShareBlock {
        updateContent(content: IYaShareContent): void;
        updateContentByService(contentByService: IYaShareContentByService): void;
        destroy(): void;
    }

    interface IYaShare {
        share2(id: string, settings: IYaShareSettings): IYaShareBlock;
    }
}
