import { IAgenciesFilter, TFilterId } from 'store/agencies/types';

export interface IFilterOption {
    id: string;
    name: string;
    preposition?: string;
    namePrepositional?: string;
    relatedId: string | null;
    certificates?: string[];
}

export interface IFilter {
    id: TFilterId;
    options: IFilterOption[];
    allowMultiple?: boolean;
    relatedFilter?: IAgenciesFilter;
}

export type TFilterGoals = {
    [id in TFilterId]?: {
        common?: string;
        options?: Record<string, string>;
    };
};
