import React from 'react';

import { useLegoComponents } from 'client/common/hooks';
import cn from 'utils/cn';
import { bindKeyset } from 'utils/i18n';

const b = cn('list-link');
const i18n = bindKeyset('agency');

interface IListLinkProps {
    url: string;
    biased?: boolean;
}

export default function AgencyListLink({ url, biased = false }: IListLinkProps) {
    const { Link: LegoLink } = useLegoComponents();

    return (
        <div className={b({ biased })}>
            <LegoLink href={url} theme="normal">
                {i18n('allagencies')}
            </LegoLink>
        </div>
    );
}
