import { useAgenciesRawFilters, useConfig } from 'client/common/hooks';

import React from 'react';
import { Helmet } from 'react-helmet';
import { connect } from 'react-redux';
import { IAppState } from 'store';

import { replaceHtmlEntities } from 'utils/helper';

import { IAgenciesTitleProps } from './AgenciesTitle.types';
import { buildTitle } from './AgenciesTitle.utils';

function mapStateToProps(state: IAppState) {
    const { filters } = state.agencies;

    return { filters };
}

function AgenciesTitle(props: IAgenciesTitleProps) {
    const { htmlMappings } = useConfig();
    const title = replaceHtmlEntities(htmlMappings, buildTitle(props.filters, useAgenciesRawFilters(), props.filtersTemplate));

    return (
        <Helmet>
            <title>{title}</title>
            <meta property="og:title" content={title} />
        </Helmet>
    );
}

export default connect(
    mapStateToProps
)(AgenciesTitle);
