import i18n from 'utils/i18n';

import { ActionType, IAgencyFormState, TAction } from './types';

const initialState = {
    name: {
        error: false,
        isEmail: false,
        isSelect: false,
        label: i18n({ keyset: 'agency', key: 'form.name' }),
        value: ''
    },
    email: {
        error: false,
        isEmail: true,
        isSelect: false,
        label: i18n({ keyset: 'agency', key: 'form.email' }),
        value: ''
    },
    comment: {
        error: false,
        isEmail: false,
        isSelect: false,
        label: i18n({ keyset: 'agency', key: 'form.message' }),
        value: ''
    }
};

export function getInitialState(): IAgencyFormState {
    return initialState;
}

function setState(state: IAgencyFormState, options: {
    error?: boolean;
    fieldName: string;
    value?: string;
}) {
    const { error, fieldName, value } = options;

    const newState: IAgencyFormState = {
        name: { ...state.name },
        email: { ...state.email },
        comment: { ...state.comment }
    };

    if (error !== undefined) {
        newState[fieldName].error = error;
    }

    if (value !== undefined) {
        newState[fieldName].value = value;
    }

    return newState;
}

export function reducer(state: IAgencyFormState, action: TAction): IAgencyFormState {
    switch (action.type) {
        case ActionType.ClearForm: {
            return initialState;
        }
        case ActionType.SetFieldError: {
            const { fieldName, error } = action.payload;

            return setState(state, {
                fieldName,
                error
            });
        }
        case ActionType.SetFieldValue: {
            const { fieldName, value } = action.payload;

            return setState(state, {
                fieldName,
                value
            });
        }
        default:
            return state;
    }
}
