export interface IAgencyFormState {
    [fieldName: string]: {
        error: boolean;
        isEmail: boolean;
        isSelect: boolean;
        label: string;
        value: string;
    };
}

export enum ActionType {
    ClearForm,
    SetFieldError,
    SetFieldValue
}

interface IClearFormAction {
    type: ActionType.ClearForm;
}

interface ISetFieldErrorAction {
    type: ActionType.SetFieldError;
    payload: {
        fieldName: string;
        error: boolean;
    };
}

interface ISetFieldValueAction {
    type: ActionType.SetFieldValue;
    payload: {
        fieldName: string;
        value: string;
    };
}

export type TAction =
    | IClearFormAction
    | ISetFieldErrorAction
    | ISetFieldValueAction;
