import React from 'react';

import PostCard from 'client/common/components/post-card';
import SolutionCard from 'client/common/components/solution-card';

import { IMaterial, MaterialType } from 'client/common/types';

import cn from 'utils/cn';
import { bindKeyset } from 'utils/i18n';

import './index.css';

const b = cn('agency-materials');
const i18n = bindKeyset('agency');

interface IAgencyMaterialsProps {
    className?: string;
    materials: IMaterial[];
}

function AgencyMaterials({ className = '', materials }: IAgencyMaterialsProps) {
    return (
        <div className={b({}, [className])}>
            {materials.map(material => {
                const { url, cardType } = material;

                if (material.type === MaterialType.case) {
                    return (
                        <SolutionCard
                            key={url}
                            className={b('card')}
                            view="agency"
                            solution={material.data}
                            url={url}
                            mark={i18n('case')}
                            cardType={cardType}
                            isDatesHidden
                            />
                    );
                }

                if (material.type === MaterialType.news) {
                    return (
                        <PostCard
                            key={url}
                            className={b('card')}
                            post={material.data}
                            url={url}
                            mark={i18n('agency-experience')}
                            cardType={cardType}
                            isDatesHidden
                            />
                    );
                }

                return null;
            })}
        </div>
    );
}

export default AgencyMaterials;
