import React, { ComponentType } from 'react';

import { useComponents } from 'client/common/hooks';
import { IAppData } from 'client/common/types';

import { getAgenciesPageProps } from './agencies';
import { getAgencyPageProps } from './agency';
import { getSolutionPageProps } from './solution';
import { getSolutionsPageProps } from './solutions';

export function usePageRenderers(data: IAppData) {
    const {
        AgencyPage,
        AgenciesPage,
        SolutionPage,
        SolutionsPage
    } = useComponents();

    function createPageRenderer<P>(Page: ComponentType<P>, getProps: (data: IAppData) => P) {
        return () => <Page {...getProps(data)} />;
    }

    return {
        agency: createPageRenderer(AgencyPage, getAgencyPageProps),
        agencies: createPageRenderer(AgenciesPage, getAgenciesPageProps),
        solution: createPageRenderer(SolutionPage, getSolutionPageProps),
        solutions: createPageRenderer(SolutionsPage, getSolutionsPageProps)
    };
}
