import { ISolutionPageProps } from 'client/common/pages/solution';
import { IAppData } from 'client/common/types';

export function getSolutionPageProps(data: IAppData): ISolutionPageProps {
    const solutionsSectionUrl = [
        data.solutionsUrl,
        data.section === '_self' ? null : data.section
    ]
        .filter(Boolean)
        .join('/');

    return {
        keywords: data.seo && data.seo.keywords,
        language: data.language,
        levels: data.levels,
        shareServices: data.shareServices.join(','),
        solutionsUrl: solutionsSectionUrl,

        solution: data.solutionsData.solution,
        isDatesHidden: data.solutionsData.solutionSection.isDatesHidden,

        filter: {
            tasks: data.solutionsData.solutionSection.tasks,
            products: data.solutionsData.solutionSection.products,
            industries: data.solutionsData.solutionSection.industries,
            companySize: data.solutionsData.solutionSection.companySize,
            changes: data.solutionsData.solutionSection.changes,
            periods: data.solutionsData.solutionSection.periods
        }
    };
}
