import { ISolutionsPageProps } from 'client/common/pages/solutions';
import { IAppData } from 'client/common/types';

export function getSolutionsPageProps(data: IAppData): ISolutionsPageProps {
    return {
        filterUrl: data.filterUrl,
        language: data.language,
        section: data.section,
        solutionsUrl: data.solutionsUrl,

        hasMore: data.solutionsData.hasMore,
        solutionsList: data.solutionsData.list,
        text: data.solutionsData.solutionsPage.text,
        title: data.solutionsData.solutionsPage.title,
        isDatesHidden: data.solutionsData.solutionsPage.isDatesHidden,

        filter: {
            companySize: data.solutionsData.solutionsPage.companySize,
            industries: data.solutionsData.solutionsPage.industries,
            products: data.solutionsData.solutionsPage.products,
            tasks: data.solutionsData.solutionsPage.tasks,
            changes: data.solutionsData.solutionsPage.changes,
            periods: data.solutionsData.solutionsPage.periods
        }
    };
}
