import React from 'react';

import cn from 'utils/cn';

import { useComponents } from 'client/common/hooks';

import './CardInformation.css';

import { ICardInformationProps } from './CardInformation.types';

const b = cn('card-information');

function CardInformation({ image, title, items }: ICardInformationProps) {
    const { HtmlContent } = useComponents();

    return (
        <div className={b('container')}>
            <div className={b('content')}>
                <div className={b('img-container-item')}>
                    <img className={b('image-item')} src={image} />
                </div>
                <div className={b('description-item')}>
                    <HtmlContent className={b('title-item')} content={title} />
                    <ul className={b('item-list')}>
                        {items.map((item: string) => (
                            <li key={item} className={b('item-marker')}>
                                <HtmlContent className={b('item-text')} content={item} />
                            </li>
                        ))}
                    </ul>
                </div>
            </div>
        </div>
    );
}

export default CardInformation;
