import React, { MouseEventHandler } from 'react';

import { useLegoComponents, useUser } from 'client/common/hooks';

import cn from 'utils/cn';

import './index.css';

const b = cn('email-sample');

interface IEmailSampleProps {
    onClick: MouseEventHandler<HTMLSpanElement>;
}

function EmailSample({ onClick }: IEmailSampleProps) {
    const { Link } = useLegoComponents();
    const { email } = useUser();

    if (!email) {
        return null;
    }

    return (
        <span className={b()}>
            <Link className={b('email')} theme="pseudo" onClick={onClick}>
                {email}
            </Link>
        </span>
    );
}

export default EmailSample;
