import React from 'react';

import { useComponents } from 'client/common/hooks';

import { IExtendedImageProps } from './ExtendedImage.type';

export default function ExtendedImage(props: IExtendedImageProps) {
    const { extendedImage, className, style } = props;
    const { PlatformWrapper, ZoomableImage } = useComponents();

    return (
        <PlatformWrapper
            component={ZoomableImage}
            fixedProps={{ ...extendedImage, className, style }}
            platformProps={
                [
                    {
                        name: 'src',
                        platforms: {
                            common: extendedImage.commonSrc,
                            desktop: extendedImage.commonSrc,
                            touch: extendedImage.touchSrc || ''
                        }
                    }
                ]
            }
            />
    );
}
