import { classnames } from '@bem-react/classnames';
import React from 'react';

import FooterPhone from 'client/common/components/footer/phone';
import Copyright from 'client/common/components/lego/copyright';
import Social from 'client/common/components/social';
import { SettingsContext } from 'client/common/contexts';
import cn from 'utils/cn';

import './index.css';

export const cnFooter = cn('footer');

function Footer() {
    return (
        <SettingsContext.Consumer>
            {settings => {
                const { footer } = settings;
                const { socialLinks, phone, text } = footer;

                const elements = [
                    { key: 'social', node: <Social socialLinks={socialLinks} /> },
                    { key: 'phone', node: <FooterPhone phone={phone} text={text} /> },
                    { key: 'copyright', node: <Copyright /> }
                ];

                return (
                    <footer className={classnames(cnFooter(), 'clearfix')}>
                        <div className={cnFooter('wrapper')}>
                            {elements.map(elem => (
                                <div key={elem.key} className={cnFooter('column')}>
                                    {elem.node}
                                </div>
                            ))}
                        </div>
                    </footer>
                );
            }
            }
        </SettingsContext.Consumer>
    );
}

export default Footer;
