import React from 'react';

import { cnFooter } from 'client/common/components/footer';

interface IFooterPhoneProps {
    phone: string;
    text: string;
}

function FooterPhone({ phone, text }: IFooterPhoneProps) {
    return (
        <div className={cnFooter('phone-wrapper')}>
            <div className={cnFooter('phone')}>
                <div className={cnFooter('phone-number')}>{phone}</div>
                <br />
                <div className={cnFooter('phone-text')}>{text}</div>
            </div>
        </div>
    );
}

export default FooterPhone;
