import React, { Fragment, ReactNode } from 'react';

export interface IFormattedContentNodes {
    [tokenName: string]: ReactNode;
}

interface IFormattedContentProps {
    template: string;
    nodes: IFormattedContentNodes;
}

const TOKEN_REG_EXP = /({{\w+}})/g;
const TOKEN_NAME_REG_EXP = /{{(\w+)}}/;

function FormattedContent({ template, nodes }: IFormattedContentProps) {
    const parts = template.split(TOKEN_REG_EXP);

    return (
        <Fragment>
            {parts.map(part => {
                const tokenName = getTokenName(part);

                return tokenName ?
                    nodes[tokenName] :
                    <span dangerouslySetInnerHTML={{ __html: part }} />;
            })}
        </Fragment>
    );
}

function getTokenName(string: string) {
    if (!isToken(string)) {
        return null;
    }

    const match = string.match(TOKEN_NAME_REG_EXP);

    return match && match[1];
}

function isToken(string: string) {
    return TOKEN_REG_EXP.test(string);
}

export default FormattedContent;
