import React from 'react';

import cn from 'utils/cn';

import './site.css';

const b = cn('site-icon');

interface ISiteProps {
    className?: string;
}

export function Site({ className }: ISiteProps) {
    return (
        <svg className={b({}, [className])} viewBox="0 0 16 16" width="16" height="16" xmlns="http://www.w3.org/2000/svg">
            <g transform="translate(-373 -20)" fill="none" fillRule="evenodd">
                <g className={b('sphere')} transform="translate(374 21)">
                    <circle cx="7" cy="7" r="7" />
                    <ellipse cx="7" cy="7" rx="2" ry="7" />
                    <path d="M.334 9h13.388M.334 5h13.388" />
                </g>
            </g>
        </svg>
    );
}
