import React from 'react';

import LegoUser from 'lego-on-react/src/components/user/user.react';

import { useConfig, useUser } from 'client/common/hooks';
import cn from 'utils/cn';

import 'lego-on-react/src/components/user/user.css';

import './index.css';

const cnUser = cn('user2');

export default function User() {
    const config = useConfig();
    const user = useUser();

    return (
        <LegoUser
            name={user.displayName}
            passportHost={config.passportHost}
            uid={user.uid}
            cls={cnUser({ adv: 'yes' })}
            retpath={config.url}
            yu={user.yandexuid}
            />
    );
}
