import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelAboutCompany } from 'client/common/types';

import { b, ILevelProps } from '..';

import './level_type_aboutCompany.css';

export interface ILevelTypeAboutCompanyProps extends Omit<ILevelAboutCompany, 'type'> {
    type?: 'aboutCompany';
}

export const withLevelTypeAboutCompany = withBemMod<ILevelTypeAboutCompanyProps, ILevelProps>(
    b(),
    { type: 'aboutCompany' },
    (BaseLevel: React.FC<ILevelProps>) => props => {

        const { blocks, ...otherProps } = props;
        const { HtmlContent } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <div className={b('content')}>
                    {blocks.map(({ title, text }) => (
                        <div key={title} className={b('info')}>
                            <HtmlContent className={b('info-section')} content={title} />
                            <HtmlContent className={b('text')} content={text} />
                        </div>
                    ))}
                </div>
            </BaseLevel>
        );
    }
);
