import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelAbstract } from 'client/common/types';

import { b, ILevelProps } from '..';

import './level_type_abstract.css';

export interface ILevelTypeAbstract extends Omit<ILevelAbstract, 'type'> {
    type?: 'abstract';
}

export const withLevelTypeAbstract = withBemMod<ILevelTypeAbstract, ILevelProps>(
    b(),
    { type: 'abstract' },
    (BaseLevel: React.FC<ILevelProps>) => props => {

        const { body, ...otherProps } = props;
        const { HtmlContent } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <HtmlContent className={b('text')} content={body} />
            </BaseLevel>
        );
    }
);
