import { withBemMod } from '@bem-react/core';
import React from 'react';

import { ILevelAdvice } from 'client/common/types';

import cn from 'utils/cn';

import { useComponents } from 'client/common/hooks';
import { s } from 'utils/findCustomStyle';

import { b, ILevelProps } from '..';

import './level_type_advice.css';

export interface ILevelTypeAbstract extends Omit<ILevelAdvice, 'type'> {
    type?: 'advice';
}

export const withLevelTypeAdvice = withBemMod<ILevelAdvice, ILevelProps>(
    b(),
    { type: 'advice' },
    (BaseLevel: React.FC<ILevelProps>) => props => {

        const {
            title,
            body,
            image,
            compact,
            customStyles,
            ...otherProps } = props;

        const classNameSize = compact ? 'compact-advice' : 'normal-advice';

        const sc = (className: string) => (`${b(className)} ${cn(classNameSize)(className)}`);
        const { HtmlContent } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <div
                    className={sc('content')}
                    style={s('Level', customStyles, ['background'])}
                    >
                    {
                        image &&
                        <img
                            src={image}
                            className={sc('img')}
                            style={s('Level', customStyles, ['color'])}
                            />
                    }
                    <p className={sc('text')}>
                        <HtmlContent
                            content={title}
                            className={sc('title')}
                            style={s('Level', customStyles, ['color'])}
                            />
                        <HtmlContent
                            content={body}
                            className={sc('body')}
                            style={s('Level', customStyles, ['color'])}
                            />
                    </p>
                </div>
            </BaseLevel>
        );
    }
);
