import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelAgency } from 'client/common/types';

import { s } from 'utils/findCustomStyle';

import { b, ILevelProps } from '..';

import './level_type_agency.css';

export interface ILevelTypeAgencyProps extends Omit<ILevelAgency, 'type'> {
    type?: 'agency';
}

export const withLevelTypeAgency = withBemMod<ILevelTypeAgencyProps, ILevelProps>(
    b(),
    { type: 'agency' },
    (BaseLevel: React.FC<ILevelProps>) => props => {

        const { images, text, customStyles, ...otherProps } = props;
        const { HtmlContent } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <div className={b('content')} style={s('Level', customStyles, ['background'])}>
                    <HtmlContent className={b('text')} content={text} style={s('Level', customStyles, ['color'])} />
                    {images.length > 0 && (
                        <div className={b('images', { size: images.length })}>
                            {images.map(({ imageSrc, url }) => (
                                <div key={url} className={b('image')}>
                                    <a
                                        href={url}
                                        target="_blank"
                                        rel="noopener noreferrer"
                                        >
                                        <img src={imageSrc} />
                                    </a>
                                </div>
                            ))}
                        </div>
                    )}
                </div>
            </BaseLevel>
        );
    }
);
