import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelAnnotatedImage } from 'client/common/types';

import { b, ILevelProps } from '..';

import './level_type_annotatedImage.css';

export interface ILevelTypeAnnotatedImageProps extends Omit<ILevelAnnotatedImage, 'type'> {
    type?: 'annotatedImage';
}

export const withLevelTypeAnnotatedImage = withBemMod<ILevelTypeAnnotatedImageProps, ILevelProps>(
    b(),
    { type: 'annotatedImage' },
    (BaseLevel: React.FC<ILevelProps>) => props => {
        const { contentTitle, body, image, imageCaption, imagePosition, ...otherProps } = props;

        const { HtmlContent } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <div className={b('content', { image: imagePosition })}>
                    <div className={b('texts-block')}>
                        <div className={b('annotation-block')}>
                            { contentTitle && <HtmlContent className={b('content-title')} content={contentTitle} /> }
                            <HtmlContent className={b('body')} content={body} />
                        </div>
                        <div className={b('caption-block')}>
                            <HtmlContent className={b('image-caption')} content={imageCaption} />
                            <div className={b('arrow')} />
                        </div>
                    </div>
                    <div className={b('subimg')}>
                        <img className={b('image')} src={image} />
                    </div>
                </div>
            </BaseLevel>
        );
    }
);
