import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelDataSummary } from 'client/common/types';

import { s } from 'utils/findCustomStyle';

import { b, ILevelProps } from '..';

import './level_type_dataSummary.css';

export interface ILevelTypeDataSummary extends Omit<ILevelDataSummary,
    | 'type'> {
    type?: 'dataSummary';
}

export const withLevelTypeDataSummary = withBemMod<ILevelTypeDataSummary, ILevelProps>(
    b(),
    { type: 'dataSummary' },
    (BaseLevel: React.FC<ILevelProps>) => props => {

        const {
            summaryTitle,
            body,
            data,
            footer,
            customStyles,
            ...otherProps } = props;

        const { HtmlContent } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <div
                    className={b('content')}
                    style={s('Level', customStyles, ['background'])}
                    >
                    <HtmlContent
                        className={b('summary-title')}
                        content={summaryTitle}
                        style={s('Level', customStyles, ['color'])}
                        />
                    <HtmlContent
                        className={b('body')}
                        content={body}
                        style={s('Level', customStyles, ['color'])}
                        />
                    <div className={b('dataSummary')}>
                        {data.map(({ title, description }) => (
                            <div key={title}>
                                <div className={b('data-card')}>
                                    <HtmlContent
                                        className={b('data-title')}
                                        content={title}
                                        style={s('Level', customStyles, ['color'])}
                                        />
                                    <HtmlContent
                                        className={b('data-description')}
                                        content={description}
                                        style={s('Level', customStyles, ['color'])}
                                        />
                                </div>
                            </div>
                        ))}
                    </div>

                    {footer && <HtmlContent
                        className={b('footer')}
                        content={footer}
                        style={s('Level', customStyles, ['color'])}
                        />}
                </div>
            </BaseLevel>
        );
    }
);
