import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents, useLegoComponents } from 'client/common/hooks';
import { ILevelDownload } from 'client/common/types';

import { b, ILevelProps } from '..';

import './level_type_download.css';

export interface ILevelTypeDownloadProps extends Omit<ILevelDownload, 'type'> {
    type?: 'download';
}

export const withLevelTypeDownload = withBemMod<ILevelTypeDownloadProps, ILevelProps>(
    b(),
    { type: 'download' },
    (BaseLevel: React.FC<ILevelProps>) => props => {
        const { Button } = useLegoComponents();
        const { HtmlContent } = useComponents();

        const { imageSrc, contentTitle, contentDescription, buttonUrl, buttonText, ...otherProps } = props;

        return (
            <BaseLevel {...otherProps}>
                <div className={b('content')}>
                    {imageSrc && <img className={b('image')} src={imageSrc} alt={contentTitle} />}
                    <div className={b('info')}>
                        <HtmlContent className={b('content-title')} content={contentTitle} />
                        {contentDescription && (
                            <HtmlContent className={b('content-description')} content={contentDescription} />
                        )}
                        <Button
                            className={b('button')}
                            theme="action"
                            size="m"
                            type="link"
                            url={buttonUrl}
                            target="_blank"
                            rel="noopener noreferrer"
                            >
                            {buttonText}
                        </Button>
                    </div>
                </div>
            </BaseLevel>
        );
    }
);
